c********************************************************************
c********************************************************************
c********************************************************************

      subroutine calcgrad(numsurf,numz,NSPTS,NZPTS,theta,fin_nn,
     &     tgrad,pgrad,zgrad,atheta,aphi,az)
      implicit double precision (a-h,o-z)
      character*100 fin_nn
      dimension theta(NSPTS,NZPTS)
      dimension tgrad(NSPTS,NZPTS),pgrad(NSPTS,NZPTS),zgrad(NSPTS,NZPTS)
      dimension atheta(NSPTS),aphi(NSPTS),az(NZPTS)
      dimension nnpts(2000), distnn(2000), azimnn(2000)

      pi = 3.141592635
      rad = pi/180.0
      re = 6371.0
      recm = re * 1.0e5

      open(29,file=fin_nn)
      do 301 ns=1,numsurf

c     Read in nearest neighbor points
         read(29,*) num,numnn
         do 303 nn=1,numnn
            read(29,*) nnpts(nn), distnn(nn), azimnn(nn)
 303     continue

         weightmin = 0.1
         do 302 nz = 1,numz

c CALCULATE tauFLOW = |D THETA / Dt|^-1 = (material derivitive of THETA)^-1:
c D/Dt = partial / partial t + u dot grad
c The first term (partial / partial t) is zero if we assume steady-state flow
c (which we have to do until we start using time-dependent models)
c The second term can be calculated by taking the spatial gradient of THETA.
c Note that this requires finding all of the points within a given distance
c of the point in question, and then taking the spatial gradient.


c     calculate horizontal gradients from nearest neighbors (units are rad/cm)
            gradtheta = 0.0
            gradphi = 0.0
            weighttheta = 0.0
            weightphi = 0.0
            sphrad = az(nz)*recm

            do 304 nn=1,numnn

c     use azimuth to separate points into the theta and phi directions
               weight = 1.0/distnn(nn)
               if ((dabs(azimnn(nn)) .lt. 30.0) .or.
     &              (dabs(azimnn(nn)) .gt. 150.0)) then
                  gradtheta = gradtheta + weight*(theta(nnpts(nn),nz) -
     &                 theta(ns,nz))/(atheta(nnpts(nn))-atheta(ns)) / 
     &                 (sphrad)
                  weighttheta = weighttheta + weight
               endif
               if ((dabs(azimnn(nn)) .gt. 60) .and.
     &              (dabs(azimnn(nn)) .lt. 120.0)) then
                  gradphi = gradphi + weight*((theta(nnpts(nn),nz) -
     &                 theta(ns,nz))/(aphi(nnpts(nn))-aphi(ns))) / 
     &                 (dsin(atheta(ns))*sphrad)
                  weightphi = weightphi + weight
               endif
 304        continue

            if (weighttheta .gt. weightmin) then 
               gradtheta = gradtheta / weighttheta
            else
               gradtheta = 0.0
               if (nz .eq. 1) then
                  alat = 90.0 - atheta(ns)/rad
                  alon = aphi(ns)/rad
                  print *, "     no theta points:", ns,alat,alon
               endif
            endif

            if (weightphi .gt. weightmin) then 
               gradphi = gradphi / weightphi
            else
               gradphi = 0.0
               if (nz .eq. 1) then
                  alat = 90.0 - atheta(ns)/rad
                  alon = aphi(ns)/rad
                  print *, "     no phi points:", ns,alat,alon
               endif
            endif

c     calculate vertical gradients (units are radians/cm)
            gradz = 0.0
            numnnz = 0
            if(nz .gt. 1) then
               gradz = gradz + (theta(ns,nz)-theta(ns,nz-1)) / 
     &              (az(nz)-az(nz-1)) / (recm)
               numnnz = numnnz + 1
            endif
            if(nz .lt. numz) then
               gradz = gradz + (theta(ns,nz+1)-theta(ns,nz)) / 
     &              (az(nz+1)-az(nz)) / (recm)
               numnnz = numnnz + 1
            endif
            gradz = gradz / dfloat(numnnz)

c horizontal gradient of THETA given as change in THETA per horizontal km
c vertical gradient of THETA given as change in THETA per km depth
            tgrad(ns,nz) = 1.0e5 * gradtheta
            pgrad(ns,nz) = 1.0e5 * gradphi
            zgrad(ns,nz) = 1.0e5 * gradz

 302     continue
 301  continue
      close(29)

      return
      end

c********************************************************************
c********************************************************************
c********************************************************************
