c********************************************************************
c********************************************************************
c********************************************************************

      subroutine calcgradv(numsurf,numz,NSPTS,NZPTS,vtheta,vphi,vz,
     &     fin_nn,atheta,aphi,az,dvtdt,dvtdp,dvtdz,dvpdt,dvpdp,dvpdz,
     &     dvzdt,dvzdp,dvzdz)

      implicit double precision (a-h,o-z)
      character*100 fin_nn
      dimension vtheta(NSPTS,NZPTS),vphi(NSPTS,NZPTS),vz(NSPTS,NZPTS)
      dimension atheta(NSPTS),aphi(NSPTS),az(NZPTS)
      dimension dvtdt(NSPTS,NZPTS),dvtdp(NSPTS,NZPTS),dvtdz(NSPTS,NZPTS)
      dimension dvpdt(NSPTS,NZPTS),dvpdp(NSPTS,NZPTS),dvpdz(NSPTS,NZPTS)
      dimension dvzdt(NSPTS,NZPTS),dvzdp(NSPTS,NZPTS),dvzdz(NSPTS,NZPTS)

      dimension nnpts(2000), distnn(2000), azimnn(2000)

c CALCULATE the velocity gradient tensor L_ij = partial v_i / partial x_j
c Defined: Kaminski and Ribe 2002, equation (1)
c it is not necessarily symmetric (the symmetric part is the stain rate)

      pi = 3.141592635
      rad = pi/180.0
      re = 6371.0
      scaling = 1.0/(365.24*24.0*3600.0)

      open(29,file=fin_nn)
      do 301 ns=1,numsurf

c     Read in nearest neighbor points
         read(29,*) num,numnn
         do 303 nn=1,numnn
            read(29,*) nnpts(nn), distnn(nn), azimnn(nn)
 303     continue

         weightmin = 0.1
         do 302 nz = 1,numz

c     calculate horizontal gradients from nearest neighbors (units are (km/yr)/km = 1/yr)
            gradvtt = 0.0
            gradvpt = 0.0
            gradvzt = 0.0
            gradvtp = 0.0
            gradvpp = 0.0
            gradvzp = 0.0

            weighttheta = 0.0
            weightphi = 0.0
            sphrad = 2.0*pi*az(nz)*re

           do 304 nn=1,numnn
               weight = 1.0/(distnn(nn))

c     use azimuth to separate points into the theta and phi directions
               if ((dabs(azimnn(nn)) .lt. 30.0) .or.
     &              (dabs(azimnn(nn)) .gt. 150.0)) then
                  gradvttnew = (vtheta(nnpts(nn),nz) - vtheta(ns,nz))
     &                 /(atheta(nnpts(nn))-atheta(ns)) / (sphrad)
                  gradvptnew = (vphi(nnpts(nn),nz) - vphi(ns,nz))
     &                 /(atheta(nnpts(nn))-atheta(ns)) / (sphrad)
                  gradvztnew = (vz(nnpts(nn),nz) - vz(ns,nz))
     &                 /(atheta(nnpts(nn))-atheta(ns)) / (sphrad)
                  gradvtt = gradvtt + weight*gradvttnew
                  gradvpt = gradvpt + weight*gradvptnew
                  gradvzt = gradvpt + weight*gradvztnew
                  weighttheta = weighttheta + weight

               endif
               if ((dabs(azimnn(nn)) .gt. 60) .and.
     &              (dabs(azimnn(nn)) .lt. 120.0)) then
                  gradvtpnew = (vtheta(nnpts(nn),nz) - vtheta(ns,nz))
     &                 /(aphi(nnpts(nn))-aphi(ns)) / 
     &                 (dsin(atheta(ns))*sphrad)
                  gradvppnew = (vphi(nnpts(nn),nz) - vphi(ns,nz))
     &                 /(aphi(nnpts(nn))-aphi(ns)) / 
     &                 (dsin(atheta(ns))*sphrad)
                  gradvzpnew = (vz(nnpts(nn),nz) - vz(ns,nz))
     &                 /(aphi(nnpts(nn))-aphi(ns)) / 
     &                 (dsin(atheta(ns))*sphrad)
                  gradvtp = gradvtp + weight*gradvtpnew
                  gradvpp = gradvpp + weight*gradvppnew
                  gradvzp = gradvzp + weight*gradvzpnew
                  weightphi = weightphi + weight
               endif

 304        continue

            if (weighttheta .gt. weightmin) then 
               gradvtt = gradvtt / weighttheta
               gradvpt = gradvpt / weighttheta
               gradvzt = gradvzt / weighttheta
            else
               gradvtt = 0.0
               gradvpt = 0.0
               gradvzt = 0.0
               if (nz .eq. 1) then
                  alat = 90.0 - atheta(ns)/rad
                  alon = aphi(ns)/rad
                  print *, "     no theta points:", ns,alat,alon
               endif
            endif

            if (weightphi .gt. weightmin) then 
               gradvtp = gradvtp / weightphi
               gradvpp = gradvpp / weightphi
               gradvzp = gradvzp / weightphi
            else
               gradvtp = 0.0
               gradvpp = 0.0
               gradvzp = 0.0
               if (nz .eq. 1) then
                  alat = 90.0 - atheta(ns)/rad
                  alon = aphi(ns)/rad
                  print *, "     no phi points:", ns,alat,alon
               endif
            endif

c     calculate vertical gradients (units are (km/yr)/km = 1/yr)
            gradvtz = 0.0
            gradvpz = 0.0
            gradvzz = 0.0
            weightz = 0.0
            if(nz .gt. 1) then
               weight = 1.0/(az(nz)-az(nz-1));
               gradvtznew = (vtheta(ns,nz)-vtheta(ns,nz-1))/ 
     &              (az(nz)-az(nz-1)) / (re)
               gradvpznew = (vphi(ns,nz)-vphi(ns,nz-1)) / 
     &              (az(nz)-az(nz-1)) / (re)
               gradvzznew = (vz(ns,nz)-vz(ns,nz-1)) / 
     &              (az(nz)-az(nz-1)) / (re)
               gradvtz = gradvtz+weight*gradvtznew
               gradvpz = gradvpz + weight*gradvpznew
               gradvzz = gradvzz + weight*gradvzznew
               weightz = weightz + weight
            endif
            if(nz .lt. numz) then
               weight = 1.0/(az(nz)-az(nz-1));
               gradvtznew = (vtheta(ns,nz+1)-vtheta(ns,nz))/ 
     &              (az(nz+1)-az(nz)) / (re)
               gradvpznew = (vphi(ns,nz+1)-vphi(ns,nz)) / 
     &              (az(nz+1)-az(nz)) / (re)
               gradvzznew = (vz(ns,nz+1)-vz(ns,nz)) / 
     &              (az(nz+1)-az(nz)) / (re)
               gradvtz = gradvtz+weight*gradvtznew
               gradvpz = gradvpz + weight*gradvpznew
               gradvzz = gradvzz + weight*gradvzznew
               weightz = weightz + weight
            endif
            gradvtz = gradvtz / weightz
            gradvpz = gradvpz / weightz
            gradvzz = gradvzz / weightz

c convert all gradients from 1/yr to 1/s

            dvtdt(ns,nz) = scaling * gradvtt
            dvtdp(ns,nz) = scaling * gradvtp
            dvtdz(ns,nz) = scaling * gradvtz
            dvpdt(ns,nz) = scaling * gradvpt
            dvpdp(ns,nz) = scaling * gradvpp
            dvpdz(ns,nz) = scaling * gradvpz
            dvzdt(ns,nz) = scaling * gradvzt
            dvzdp(ns,nz) = scaling * gradvzp
            dvzdz(ns,nz) = scaling * gradvzz


 302     continue
 301  continue
      close(29)

      return
      end

c********************************************************************
c********************************************************************
c********************************************************************
