      program main
      
      implicit double precision (a-h,o-z)

      parameter(NLAT=75,NLON=75,NZPTS=60)
      parameter(NSPTS=NLAT*NLON*12)
      parameter(NTPTS=NSPTS*NZPTS)

      character*100 fin_coord,fin_v,fin_nn,fin_str
      character*100 fin_time,fin_coordtd,fin_vtd,fin_strtd
      character*100 fout_ehat,fout_theta,fout_thetatd,fout_pi
      character*100 fout_tgrad,fout_pgrad,fout_zgrad
      character*100 fout_tauisa,fout_tauflow,fout_pidt,fout_pigrad
      dimension atheta(NSPTS),aphi(NSPTS),az(NZPTS),avisc(NSPTS,NZPTS)
      dimension vtheta(NSPTS,NZPTS),vphi(NSPTS,NZPTS),vz(NSPTS,NZPTS)
      dimension ath2(NSPTS),aphi2(NSPTS),az2(NZPTS),avisc2(NSPTS,NZPTS)
      dimension vth2(NSPTS,NZPTS),vphi2(NSPTS,NZPTS),vz2(NSPTS,NZPTS)
      dimension tgrad(NSPTS,NZPTS),pgrad(NSPTS,NZPTS),zgrad(NSPTS,NZPTS)
      dimension tauISA(NSPTS,NZPTS),tauISAtd(NSPTS,NZPTS)
      dimension tauFLOW(NSPTS,NZPTS)
      dimension theta(NSPTS,NZPTS),thetatd(NSPTS,NZPTS)
      dimension PIout(NSPTS,NZPTS)
      dimension PIdt(NSPTS,NZPTS),PIgrad(NSPTS,NZPTS)
      dimension dvtdt(NSPTS,NZPTS),dvtdp(NSPTS,NZPTS),dvtdz(NSPTS,NZPTS)
      dimension dvpdt(NSPTS,NZPTS),dvpdp(NSPTS,NZPTS),dvpdz(NSPTS,NZPTS)
      dimension dvzdt(NSPTS,NZPTS),dvzdp(NSPTS,NZPTS),dvzdz(NSPTS,NZPTS)

c code to calculation the parameter PI - following the following reference:
c Kaminski, E, and N.M Ribe, Timescales for the evolution of seismic
c      anisotropy in mantle flow, Geochem. Geophys. Geosyst., 3(8),
c      10.1029/2001GC000222, 2002.

c INPUT PARAMETERS

c resolution
      read (5,*) numx, numy, numz
c input files (coordinates, velocity, stress(later converted to strainrate))
      read (5,1001) fin_coord
      read (5,1001) fin_v
      read (5,1001) fin_str
      read (5,*) icalctd,istep1,istep2
      read (5,1001) fin_time
      read (5,1001) fin_coordtd
      read (5,1001) fin_vtd
      read (5,1001) fin_strtd
      read (5,1001) fin_nn
c output file (for PI)
      read (5,*) ioehat,iotheta,iothetatd,iopi
      read (5,1001) fout_ehat
      read (5,1001) fout_theta
      read (5,1001) fout_thetatd
      read (5,1001) fout_pi
      read (5,*) iotgrad,iopgrad,iozgrad
      read (5,1001) fout_tgrad
      read (5,1001) fout_pgrad
      read (5,1001) fout_zgrad
      read (5,*) iotauisa,iotauflow,iopidt,iopigrad
      read (5,1001) fout_tauisa
      read (5,1001) fout_tauflow
      read (5,1001) fout_pidt
      read (5,1001) fout_pigrad


c READ IN INPUT DATA
c     coordinate data
      numsurf = (numx-1)*(numy-1)*12 + 2
      print *, "Reading coordinate data"
      call readcoord(numsurf,numz,NSPTS,NZPTS,fin_coord,
     &     atheta,aphi,az,avisc)

c     velocity data
      print *, "Reading velocity data"
      call readvel(numsurf,numz,NSPTS,NZPTS,fin_v,
     &     vtheta,vphi,vz)

      print *, "Calculating THETA and tauISA"
      call calctheta(numsurf,numz,NSPTS,NZPTS,ioehat,fin_nn,
     &     fin_str,fout_ehat,atheta,aphi,az,vtheta,vphi,vz,avisc,
     &     dvtdt,dvtdp,dvtdz,dvpdt,dvpdp,dvpdz,dvzdt,dvzdp,dvzdz,
     &     tauISA,theta)

      print *, "Calculating Gradients of THETA"
      call calcgrad(numsurf,numz,NSPTS,NZPTS,theta,fin_nn,
     &     tgrad,pgrad,zgrad,atheta,aphi,az)

      print *, "run in time-dependent mode?"
      call timedep(numsurf,numz,NSPTS,NZPTS,icalctd,
     &     istep1,istep2,fin_time,deltat)

      if (icalctd .eq. 1) then
         print *, "reading coordinates for time #2"
         call readcoord(numsurf,numz,NSPTS,NZPTS,fin_coordtd,
     &        ath2,aphi2,az2,avisc2)
         print *, "reading velocities for time #2"
         call readvel(numsurf,numz,NSPTS,NZPTS,fin_vtd,
     &        vth2,vphi2,vz2)
         ioehat=0
         print *, "running calctheta #2"
         call calctheta(numsurf,numz,NSPTS,NZPTS,ioehat,fin_nn,
     &        fin_strtd,fout_ehat,ath2,aphi2,az2,vth2,vphi2,vz2,avisc2,
     &        dvtdt,dvtdp,dvtdz,dvpdt,dvpdp,dvpdz,dvzdt,dvzdp,dvzdz,
     &        tauISAtd,thetatd)
         print *, "Time-dependent theta calculated after time ", deltat,
     &        " years."

      else
c     If we already know that thetatd is equal to THETA, then we can set it so:
         do 404 ns=1,numsurf
            do 403 nz = 1,numz
               thetatd(ns,nz) = theta(ns,nz)
 403           continue
 404           continue
         
         print *, "Time-dependence set to zero in input file."
       endif
       
c     redefine thetatd to give the difference between the two values of theta
c     (that is thetatd = thetatd - theta
       do 401 ns=1,numsurf
          do 402 nz = 1,numz
             thetatd(ns,nz) = thetatd(ns,nz) - theta(ns,nz)
 402      continue
 401   continue
       

      print *, "Calculating tauFLOW and PI"
      do 301 ns=1,numsurf
         do 302 nz = 1,numz
c     CALCULATE tauFLOW, which is the gradient multiplied by the flow vectors.
c     Result is in seconds (must convert from yr to sec)
c OLD DEF            dthetadt = (thetatd(ns,nz)-theta(ns,nz))/deltat
            dthetadt = thetatd(ns,nz)/deltat
            vdotgradtheta = vtheta(ns,nz)*tgrad(ns,nz) +
     &           vphi(ns,nz)*pgrad(ns,nz) + vz(ns,nz)*zgrad(ns,nz)
            taurate = dabs(dthetadt + vdotgradtheta)
            taucut = 1.0e-40
            if (taurate .gt. taucut) then
               tauFLOW(ns,nz) = 3.156e7 / taurate
            else
               tauFLOW(ns,nz) = tauFLOW(ns,nz-1)
            endif
            
c     CALCULATE PIout = tauISA / tauFLOW
            PIout(ns,nz) = tauISA(ns,nz) / tauFLOW(ns,nz)
            PIdt(ns,nz) = tauISA(ns,nz) * dabs(dthetadt)/3.156e7
            PIgrad(ns,nz) = tauISA(ns,nz) * dabs(vdotgradtheta)/3.156e7

 302     continue
 301  continue


c OUTPUT Variables
      print *, "Writing Output Files"
      if (iotheta .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_theta,theta)
      if (iothetatd .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_thetatd,thetatd)
      if (iopi .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_pi,PIout)
      if (iotgrad .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_tgrad,tgrad)
      if (iopgrad .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_pgrad,pgrad)
      if (iozgrad .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_zgrad,zgrad)
      if (iotauisa .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_tauisa,tauISA)
      if (iotauflow .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_tauflow,tauFLOW)
      if (iopidt .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_pidt,pidt)
      if (iopigrad .eq. 1)
     &     call outfield(numsurf,numz,NSPTS,NZPTS,fout_pigrad,pigrad)

 1001 format( a )

      stop
      end

