c********************************************************************
c********************************************************************
c********************************************************************

      subroutine calctheta(numsurf,numz,NSPTS,NZPTS,ioehat,fin_nn,
     &     fin_str,fout_ehat,atheta,aphi,az,vtheta,vphi,vz,avisc,
     &     dvtdt,dvtdp,dvtdz,dvpdt,dvpdp,dvpdz,dvzdt,dvzdp,dvzdz,
     &     tauISA,theta)
      implicit double precision (a-h,o-z)
      character*100 fout_ehat,fin_nn,fin_str,fout_vort
      dimension tauISA(NSPTS,NZPTS),theta(NSPTS,NZPTS)
      dimension atheta(NSPTS),aphi(NSPTS),az(NZPTS),avisc(NSPTS,NZPTS)
      dimension vtheta(NSPTS,NZPTS),vphi(NSPTS,NZPTS),vz(NSPTS,NZPTS)
      dimension dvtdt(NSPTS,NZPTS),dvtdp(NSPTS,NZPTS),dvtdz(NSPTS,NZPTS)
      dimension dvpdt(NSPTS,NZPTS),dvpdp(NSPTS,NZPTS),dvpdz(NSPTS,NZPTS)
      dimension dvzdt(NSPTS,NZPTS),dvzdp(NSPTS,NZPTS),dvzdz(NSPTS,NZPTS)
      double precision d(3), v(3,3), f(3,3), ft(3,3), u(3,3)
      double precision lidn(3,3), lmat(3,3), lmul(3,3), ltemp(3,3)

      pi = 3.141592635
      pitwo = pi/2.0
      strscale = 1.0e-6*1.0e21/(6370000.0*6370000.0);
      viscscale = 1.0e21

c      print *, "Calculating velocity derivitive tensor"
c      call calcgradv(numsurf,numz,NSPTS,NZPTS,vtheta,vphi,vz,
c     &     fin_nn,atheta,aphi,az,dvtdt,dvtdp,dvtdz,dvpdt,dvpdp,dvpdz,
c     &     dvzdt,dvzdp,dvzdz)

      

      open(18,file=fin_str)
      kfout_ehat = index(fout_ehat,' ')
      fout_vort = fout_ehat(1:(kfout_ehat-1)) // "vort"

      if (ioehat .eq. 1)  then
         open(19,file=fout_ehat)
c         open(20,file=fout_vort)
      endif
      do 201 ns=1,numsurf
         do 202 nz = 1,numz

c Read in strainrate
            read(18,*,END=201) szz,szy,sxz,syy,sxy,sxx
            strpress = (szz+syy+sxx)/3.0
            viscpt = avisc(ns,nz) * viscscale
            szz = (szz-strpress)*strscale/(2*viscpt);
            szy = szy*strscale/(2*viscpt);
            sxz = sxz*strscale/(2*viscpt);
            syy = (syy-strpress)*strscale/(2*viscpt);
            sxy = sxy*strscale/(2*viscpt);
            sxx = (sxx-strpress)*strscale/(2*viscpt);

c get strainrate tensor from the velocity gradient tensor
c            szz =  dvzdz(ns,nz)
c            szy = (dvzdp(ns,nz) + dvpdz(ns,nz))/2.0
c            sxz = (dvzdt(ns,nz) + dvtdz(ns,nz))/2.0
c            syy =  dvpdp(ns,nz)
c            sxy = (dvtdp(ns,nz) + dvpdt(ns,nz))/2.0
c            sxx =  dvtdt(ns,nz)
c CALCULATE tauISA = infinite strain axis. This is the inverse of the
c absolute value of the largest eigenvalue, epsilondot, of the strain rate
c tensor (see Kaminski & Ribe, 2002, page 6)

            call calctauisa(sxx,sxy,sxz,syy,szy,szz,tauISA(ns,nz))
c CALCULATE ehat, the orientation of the infinite strain axis. See appendix A
c of Kaminski & Ribe, 2002 (page 15). ehat is determined by calculating
c F = I + Lt + L^2t/2! + L^3t/3! + ...
c where L is the strain rate tensor and I is the identity tensor. For the time,
c Kaminski & Ribe (2002) show that a value of (t = 75 / epsilondot) is
c appropriate. (epsilondot is the largest eigenvalue of the strain-rate tensor.

            tmax = 75 * tauISA(ns,nz)
            aone = 1.0
            azero = 0.0
            call assmbl(lidn,aone,azero,azero,aone,azero,aone)
c Set up l matrix from the velocity gradient tensor
c            lmat(1,1) = dvtdt(ns,nz)
c            lmat(1,2) = dvtdp(ns,nz)
c            lmat(1,3) = dvtdz(ns,nz)
c            lmat(2,1) = dvpdt(ns,nz)
c            lmat(2,2) = dvpdp(ns,nz)
c            lmat(2,3) = dvpdz(ns,nz)
c            lmat(3,1) = dvzdt(ns,nz)
c            lmat(3,2) = dvzdp(ns,nz)
c            lmat(3,3) = dvzdz(ns,nz)
            lmat(1,1) = 0
            lmat(1,2) = 0
            lmat(1,3) = 2*sxz
            lmat(2,1) = 0
            lmat(2,2) = 0
            lmat(2,3) = 2*szy
            lmat(3,1) = 0
            lmat(3,2) = 0
            lmat(3,3) = szz

            call calctauisa(0.0,0.0,sxz,0.0,szy,szz,taushear)
            vorticity = sqrt(sxz*sxz + szy*szy)*taushear


c Test to see if you get the right answer for shear flow. Should
c give (0.7,-0.7,0) for (v1,v2,v3)
c            if ((ns .eq. 1000) .and. (nz .eq. 29)) then
c               lmat(1,1)=1.0/tauISA(ns,nz)
c               lmat(1,2)=1.0/tauISA(ns,nz)
c               lmat(1,3)=0.0
c               lmat(2,1)=-1.0/tauISA(ns,nz)
c               lmat(2,2)=-1.0/tauISA(ns,nz)
c               lmat(2,3)=0.0
c               lmat(3,1)=0.0
c               lmat(3,2)=0.0
c               lmat(3,3)=0.0
c               print *, "e1=",lmat(1,1),lmat(1,2),lmat(1,3)
c               print *, "e2=",lmat(2,1),lmat(2,2),lmat(2,3)
c               print *, "e3=",lmat(3,1),lmat(3,2),lmat(3,3)
c            endif
c Another test to see if you get the right answer for shear flow. Should
c give (1,0,0) for (v1,v2,v3)
c            if ((ns .eq. 1000) .and. (nz .eq. 25)) then
c               lmat(1,1)=0.0/tauISA(ns,nz)
c               lmat(1,2)=0.0/tauISA(ns,nz)
c               lmat(1,3)=1.0/tauISA(ns,nz)
c               lmat(2,1)=0.0/tauISA(ns,nz)
c               lmat(2,2)=0.0/tauISA(ns,nz)
c               lmat(2,3)=0.0
c               lmat(3,1)=0.0
c               lmat(3,2)=0.0
c               lmat(3,3)=0.0
c               print *, "l1=",lmat(1,1),lmat(1,2),lmat(1,3)
c               print *, "l2=",lmat(2,1),lmat(2,2),lmat(2,3)
c               print *, "l3=",lmat(3,1),lmat(3,2),lmat(3,3)
c            endif

            maxorder = 4
            call movemat(lidn,f)
            do 601 iorder = 1,maxorder
               
               call movemat(lidn,lmul)
               factor = 1.0
               do 602 io=1,iorder
                  call multmat(lmul,lmat,ltemp)
                  call movemat(ltemp,lmul)
                  factor = factor*tmax/float(io)
 602           continue

               call multfac(lmul,factor,ltemp)
               call movemat(ltemp,lmul)

              call addmat(f,lmul,ltemp)
               call movemat(ltemp,f)

 601        continue

            call transmat(f,ft)
c THIS IS WHAT IS IN KAMINSKI & RIBE 2002: IT IS WRONG!
c            call multmat(ft,f,u)
c THIS IS WHAT IT SHOULD BE:
            call multmat(f,ft,u)
            call jacobi(u,3,3,d,v,nrot)
            call eigsrt(d,v,3,3)

c            if ((ns .eq. 1000) .and. (nz .eq. 29)) then
c               print *, "f1=",f(1,1),f(1,2),f(1,3)
c               print *, "f2=",f(2,1),f(2,2),f(2,3)
c               print *, "f3=",f(3,1),f(3,2),f(3,3)
c               print *, "u1=",u(1,1),u(1,2),u(1,3)
c               print *, "u2=",u(2,1),u(2,2),u(2,3)
c               print *, "u3=",u(3,1),u(3,2),u(3,3)
c               print *, "d1=",d(1)
c               print *, "d2=",d(2)
c               print *, "d3=",d(3)
c               print *, "v1=",v(1,1),v(1,2),v(1,3)
c               print *, "v2=",v(2,1),v(2,2),v(2,3)
c               print *, "v3=",v(3,1),v(3,2),v(3,3)
c            endif

            if (ioehat .eq. 1) write(19,1006) v(1,1),v(2,1),v(3,1)
c            if (ioehat .eq. 1) write(20,1007) vorticity

c CALCULATE THETA = arccos (uhat dot ehat). Here uhat = u/|u| is the flow
c direction. THETA is the angle between the flow direction and the ISA ehat.

            vmag = dsqrt(vtheta(ns,nz)*vtheta(ns,nz) +
     &           vphi(ns,nz)*vphi(ns,nz) + vz(ns,nz)*vz(ns,nz))
            vmagcut = 1.0e-40
            if(vmag .gt. vmagcut) then
               dotprod = (vtheta(ns,nz)*v(1,1) + vphi(ns,nz)*v(2,1) +
     &              vz(ns,nz)*v(3,1)) / vmag
               theta(ns,nz) = dacos(dotprod)
               if(theta(ns,nz) .gt. pitwo) then
                  theta(ns,nz) = pi - theta(ns,nz)
               endif
            else
               theta(ns,nz) = 0
            endif

 202     continue
 201  continue
      close(18)
      if (ioehat .eq. 1) close(19)
      if (ioehat .eq. 1) close(20)

 1006 format(f7.4,1x,f7.4,1x,f7.4)
 1007 format(f7.4)

      return
      end

c********************************************************************
c********************************************************************
c********************************************************************

      subroutine calctauisa(sxx,sxy,sxz,syy,szy,szz,tauISA)
      implicit double precision (a-h,o-z)
      double precision a(3,3), d(3), v(3,3)

      call assmbl(a,sxx,sxy,sxz,syy,szy,szz)
      call jacobi(a,3,3,d,v,nrot)
      call eigsrt(d,v,3,3)
      if (abs(d(1)) .ge. abs(d(3))) then
c choose positive eigenvalue as the largest
         tauISA = 1.0/abs(d(1))
      else
c choose negative eigenvalue as the largest
         tauISA = 1.0/abs(d(3))
      endif

      return
      end

c********************************************************************
c********************************************************************
c********************************************************************

      subroutine timedep(numsurf,numz,NSPTS,NZPTS,icalctd,
     &     istep1,istep2,fin_time,deltat)
      implicit double precision (a-h,o-z)
      character*100 fin_coordtd,fin_vtd,fin_strtd,fin_time,fin_nn

      pi = 3.141592635
      pitwo = pi/2.0
      strscale = 1.0e-6*1.0e21/(6370000.0*6370000.0);
      viscscale = 1.0e21
      
      re = 6371.0
      thermdiff = 1.0e-6;
      erad = re*1000
      dimtokmperyr = (thermdiff/erad)*(100.0*365.25*24*3600)/1.0e5
      timescale = (erad*erad/thermdiff) / (3600*24*365.24)

c     Read in time between timesteps. Convert dimensionless units to yr.
      if (istep1 .eq. 0) then
         timetot1 = 0.0
      else
         open(15,file=fin_time)
         do 403 istepnum = 1,istep1
            read(15,*) nstep,timetot1,timedeltat,cputot,cpudeltat
 403     continue
         close(15)
      endif
      if (istep2 .eq. 0) then
         timetot2 = 0.0
      else
         open(15,file=fin_time)
         do 404 istepnum = 1,istep2
            read(15,*) nstep,timetot2,timedeltat,cputot,cpudeltat
 404     continue
         close(15)
      endif

      if (icalctd .eq. 1) then
         timetot = timetot2 - timetot1
         deltat = timetot * timescale
         print *, "time start = ", istep1,timetot1
         print *, "time end   = ", istep2,timetot2
         print *, "conversion factor (yrs) = ",timescale
         print *, "total time (yrs) = ",deltat
      else
         deltat = 9.999e6
         print *, "no time-dependence (set in inputfile)"
      endif

      return
      end



c********************************************************************
c********************************************************************
c********************************************************************
