      program main
      
      implicit double precision (a-h,o-z)

      parameter(NLAT=100,NLON=100,NZPTS=100,NSAVE=100000)
      parameter(NSPTS=NLAT*NLON*12)
      parameter(NTPTS=NSPTS*NZPTS)

      character*100 fin_coord,fout_nn
      dimension atheta(NSPTS),aphi(NSPTS)
      dimension isavens(NSAVE), dist(NSAVE)

      pi = 3.141592635
      rad = pi/180.0;
      re = 6371.0

c code to find nearest neighbors for each point in the coordinates
c of a given citcom output. This is useful for interpolation and
c gradient calculation

c INPUT PARAMETERS

c resolution
      read (5,*) numx, numy, numz
c cutoff for nearest neighbor calculation (fraction of the grid resolution)
      read (5,*) cutnn
c input files (coordinates, velocity, stress(later converted to strainrate))
      read (5,1001) fin_coord
c output file (for PI)
      read (5,1001) fout_nn

c READ IN INPUT DATA
c     coordinate data
      print *, "Reading coordinate data"
      open(16,file=fin_coord)
      numsurf = (numx-1)*(numy-1)*12 + 2
      do 101 ns=1,numsurf
         do 102 nz = 1,numz
            read(16,*,END=102) atheta(ns),aphi(ns),az,atemp,avisc
 102     continue
 101  continue
      close(16)

c     open output file
      open(17,file=fout_nn)

c     find the nearest-neighbor cutoff distance (in radians)
      cutoffdist = cutnn*(2*pi)/(4*numx*sqrt(2.0))
      alatcut = 45.0
      print *, "Find Nearest Neighbors and Output, cutoff=",cutoffdist
      open(17,file=fout_nn)
      do 201 ns=1,numsurf

         numns = 0
         do 202 nsi=1,numsurf
            call finddist(atheta(ns),aphi(ns),atheta(nsi),aphi(nsi),dis)
c            print *,nsi,dis
            alatdiff = dabs(aphi(ns) - aphi(nsi))*180/pi
            if (alatdiff .gt. 180) then
               alatdiff = 360-alatdiff
            endif
            if((dis .le. cutoffdist).and.(nsi .ne. ns).and.
     &           (alatdiff.lt.alatcut)) then
               numns = numns + 1
               isavens(numns) = nsi
               dist(numns) = dis*180.0/pi
            endif
 202     continue
         write(17,1005) ns, numns
         do 203 nsi=1,numns
            call findazim(atheta(ns),aphi(ns),atheta(isavens(nsi)),
     &           aphi(isavens(nsi)),azim)
            write(17,1006) isavens(nsi),dist(nsi),azim
 203     continue

 201  continue
      close(17)

 1001 format( a )
 1005 format(i6,1x,i4)
 1006 format(2x,i6,1x,f7.4,1x,f8.3)

      stop
      end

c********************************************************************
c********************************************************************
c********************************************************************

      subroutine finddist(tlat1,tlon1,tlat2,tlon2,dist)
      implicit double precision (a-h,o-z)

      x = dcos(tlat1) * dcos(tlat2) +
     &     dsin(tlat1) * dsin(tlat2) *
     &     dcos(tlon1 - tlon2);
      if (x .gt. 1.0) x = 1.0
      if (x .lt.-1.0) x =-1.0
      dist = datan2(dsqrt(1-x*x),x)

      return
      end

c********************************************************************
c********************************************************************
c********************************************************************

      subroutine findazim(tlat1,tlon1,tlat2,tlon2,azim)
      implicit double precision (a-h,o-z)

      pi = 3.141592635

      dphi = tlon2-tlon1
      cosdst = dcos(tlat1)*dcos(tlat2) +
     &     dsin(tlat1)*dsin(tlat2)*dcos(dphi)
      sinaz = dsin(dphi)*dsin(tlat2)/dsin( dacos(cosdst) );
      if (sinaz.ge.1.0) then
         sinaz=1.0
      endif
      signcosaz = dcos(tlat2) - (dcos(tlat1) * cosdst);
      az = dasin(sinaz)
      if (signcosaz .lt. 0.0) then
         if (az .ge. 0.0) then
            az = pi-az
         else
            az = -pi-az
         endif
      endif
      
      azim = az * 180.0 / pi
      
      return
      end

c********************************************************************
c********************************************************************
c********************************************************************

