c********************************************************************
c********************************************************************
c********************************************************************

      subroutine readcoord(numsurf,numz,NSPTS,NZPTS,fin_coord,
     &     atheta,aphi,az,avisc)
      implicit double precision (a-h,o-z)
      character*100 fin_coord
      dimension atheta(NSPTS),aphi(NSPTS),az(NZPTS)
      dimension avisc(NSPTS,NZPTS)

      open(16,file=fin_coord)
      do 101 ns=1,numsurf
         do 102 nz = 1,numz
            read(16,*,END=102) atheta(ns),aphi(ns),az(nz),
     &           atemp,avisc(ns,nz)
 102     continue
 101  continue
      close(16)

      return
      end

c********************************************************************
c********************************************************************
c********************************************************************

      subroutine readvel(numsurf,numz,NSPTS,NZPTS,fin_v,
     &     vtheta,vphi,vz)
      implicit double precision (a-h,o-z)
      character*100 fin_v
      dimension vtheta(NSPTS,NZPTS),vphi(NSPTS,NZPTS),vz(NSPTS,NZPTS)

c     velocity data
c     scaling to give km/yr (dimtokmperyr has value of 0.000495/1.0e5 = 1.0e-5/2019)

      re = 6371.0
      thermdiff = 1.0e-6;
      erad = re*1000
      dimtokmperyr = (thermdiff/erad)*(100.0*365.25*24*3600)/1.0e5
      open(17,file=fin_v)
      do 103 ns=1,numsurf
         do 104 nz = 1,numz
            read(17,*,END=104) vtheta(ns,nz), vphi(ns,nz), vz(ns,nz)
            vtheta(ns,nz) = vtheta(ns,nz)*dimtokmperyr
            vphi(ns,nz) = vphi(ns,nz)*dimtokmperyr
            vz(ns,nz) = vz(ns,nz)*dimtokmperyr
 104     continue
 103  continue
      close(17)

      return
      end

c********************************************************************
c********************************************************************
c********************************************************************
